/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import com.google.common.annotations.VisibleForTesting;
import java.util.Comparator;
import java.util.List;
import net.minecraft.world.item.Tier;
import net.minecraftforge.common.TierSortingRegistry;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.tools.stat.ToolStatsBuilder;
import slimeknights.tconstruct.library.utils.HarvestTiers;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;

public final class MeleeHarvestToolStatsBuilder
extends ToolStatsBuilder {
    private final List<HeadMaterialStats> heads;
    private final List<HandleMaterialStats> handles;
    private final List<ExtraMaterialStats> extras;

    @VisibleForTesting
    public MeleeHarvestToolStatsBuilder(ToolDefinitionData toolData, List<HeadMaterialStats> heads, List<HandleMaterialStats> handles, List<ExtraMaterialStats> extras) {
        super(toolData);
        this.heads = heads;
        this.handles = handles;
        this.extras = extras;
    }

    public static ToolStatsBuilder from(ToolDefinition toolDefinition, MaterialNBT materials) {
        ToolDefinitionData data = toolDefinition.getData();
        List<PartRequirement> requiredComponents = data.getParts();
        if (materials.size() != requiredComponents.size()) {
            return ToolStatsBuilder.noParts(toolDefinition);
        }
        return new MeleeHarvestToolStatsBuilder(data, MeleeHarvestToolStatsBuilder.listOfCompatibleWith(HeadMaterialStats.ID, materials, requiredComponents), MeleeHarvestToolStatsBuilder.listOfCompatibleWith(HandleMaterialStats.ID, materials, requiredComponents), MeleeHarvestToolStatsBuilder.listOfCompatibleWith(ExtraMaterialStats.ID, materials, requiredComponents));
    }

    @Override
    protected void setStats(StatsNBT.Builder builder) {
        builder.set(ToolStats.DURABILITY, Float.valueOf(this.buildDurability()));
        builder.set(ToolStats.HARVEST_TIER, this.buildHarvestLevel());
        builder.set(ToolStats.ATTACK_DAMAGE, Float.valueOf(this.buildAttackDamage()));
        builder.set(ToolStats.ATTACK_SPEED, Float.valueOf(this.buildAttackSpeed()));
        builder.set(ToolStats.MINING_SPEED, Float.valueOf(this.buildMiningSpeed()));
    }

    @Override
    protected boolean handles(IToolStat<?> stat) {
        return stat == ToolStats.DURABILITY || stat == ToolStats.HARVEST_TIER || stat == ToolStats.ATTACK_DAMAGE || stat == ToolStats.ATTACK_SPEED || stat == ToolStats.MINING_SPEED;
    }

    public float buildDurability() {
        double averageHeadDurability = MeleeHarvestToolStatsBuilder.getAverageValue(this.heads, HeadMaterialStats::getDurability) + (double)this.getStatOrDefault(ToolStats.DURABILITY, Float.valueOf(0.0f)).floatValue();
        double averageHandleModifier = MeleeHarvestToolStatsBuilder.getAverageValue(this.handles, HandleMaterialStats::getDurability, 1.0);
        return Math.max(1, (int)(averageHeadDurability * averageHandleModifier));
    }

    public float buildMiningSpeed() {
        double averageHeadSpeed = MeleeHarvestToolStatsBuilder.getAverageValue(this.heads, HeadMaterialStats::getMiningSpeed) + (double)this.getStatOrDefault(ToolStats.MINING_SPEED, Float.valueOf(0.0f)).floatValue();
        double averageHandleModifier = MeleeHarvestToolStatsBuilder.getAverageValue(this.handles, HandleMaterialStats::getMiningSpeed, 1.0);
        return (float)Math.max(0.1, averageHeadSpeed * averageHandleModifier);
    }

    public float buildAttackSpeed() {
        float baseSpeed = this.toolData.getBaseStat(ToolStats.ATTACK_SPEED).floatValue();
        double averageHandleModifier = MeleeHarvestToolStatsBuilder.getAverageValue(this.handles, HandleMaterialStats::getAttackSpeed, 1.0);
        return (float)Math.max(0.0, (double)baseSpeed * averageHandleModifier);
    }

    public Tier buildHarvestLevel() {
        List sortedTiers = TierSortingRegistry.getSortedTiers();
        return this.heads.stream().map(HeadMaterialStats::getTier).max(Comparator.comparingInt(sortedTiers::indexOf)).orElse(HarvestTiers.minTier());
    }

    public float buildAttackDamage() {
        double averageHeadAttack = MeleeHarvestToolStatsBuilder.getAverageValue(this.heads, HeadMaterialStats::getAttack) + (double)this.getStatOrDefault(ToolStats.ATTACK_DAMAGE, Float.valueOf(0.0f)).floatValue();
        double averageHandle = MeleeHarvestToolStatsBuilder.getAverageValue(this.handles, HandleMaterialStats::getAttackDamage, 1.0);
        return (float)Math.max(0.0, averageHeadAttack * averageHandle);
    }

    protected List<HeadMaterialStats> getHeads() {
        return this.heads;
    }

    protected List<HandleMaterialStats> getHandles() {
        return this.handles;
    }

    protected List<ExtraMaterialStats> getExtras() {
        return this.extras;
    }
}

